﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web.UI;
using System.Web.UI.WebControls;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessManager;
using VeteransAffairs.Registries.BusinessManager.TBI;
using BusinessHelper = VeteransAffairs.Registries.Business.Utilities.Helpers;

public partial class TBI_Instruments_MedRed_LCI_v2 : BaseTBIInstrumentPage {

    #region Variable Declarations

    PatientManager patientManager = new PatientManager();
    InstrumentType instrumentType = new InstrumentType();

    protected int _surveyTypeId = 8; // Database Id for MedRed_LCI_v2

    SURVEY _survey;   // the root object in the Survey set
    SURVEY_RESULT _surveyResult; // the object representing the actual data in the Survey

    List<STD_QUESTION> QuestionList = new List<STD_QUESTION>();
    public delegate void MasterPageMenuClickHandler(object sender, MenuEventArgs e);
    public event MasterPageMenuClickHandler MenuClick;
    #endregion

    /// <summary>
    /// Default Constructor
    /// </summary>
    public TBI_Instruments_MedRed_LCI_v2() {
        //Manager Save Notification Event Handler
        patientManager.BOSaveSuccess += manager_BOSaveSuccess;
    }

    protected void Menu2_MenuItemClick(object sender, MenuEventArgs e)
    {
        if (MenuClick != null)
        {
            MenuClick(sender, e);
        }
    }


    #region Protected Methods

    /// <summary>
    /// Page Load Method
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void Page_Load(object sender, EventArgs e) {
        TBIServiceTO _tbiServiceTo;

        try {
            // confirm instrument is active - if not, a redirect will occur.
            this.CheckActiveStatus(_surveyTypeId);

            _tbiServiceTo = (TBIServiceTO)Session["TBIServiceTO"];
            _tbiInstrumentManager.TbiServiceTo = _tbiServiceTo;

            string instTitle = _tbiInstrumentManager.GetInstrumentByID(_surveyTypeId).Name;

            LabelBreadCrumb.Text = "TBI Instruments > Instrument Associations > " + instTitle;
            LabelInstrumentTitle.Text = instTitle;
            Page.Title = "TBI Instruments - " + instTitle;

            if (_tbiInstrumentManager.TbiServiceTo != null) {
                Label labelUser = (Label)Master.FindControl("LabelCurrentUser");
                labelUser.Text = BusinessHelper.FixStringToPreventXss(_tbiInstrumentManager.TbiServiceTo.UserName);

                LabelPatient.Text = BusinessHelper.FixStringToPreventXss(_tbiInstrumentManager.TbiServiceTo.PatientName);
                LabelSSN.Text = BusinessHelper.FixStringToPreventXss(_tbiInstrumentManager.TbiServiceTo.PatientSnum);
            }
        } catch (Exception ex) {
            //Redirect to message that session is ended and need to log back in from CPRS.
            Exception _tbilogerror = HandleTBIException(ex, "MedRed_LCI-v2.aspx", "100027", "SESSIOENDED");
            Response.Redirect("Warning.aspx?err=2", false);
        }

        if (!IsPostBack) {
            if (instrumentType.Status != null) {
                _tbiInstrumentManager.TbiServiceTo.SelectedInstrumentType = instrumentType;
            }

            string _snum = "";
            if (_tbiInstrumentManager.TbiServiceTo != null) {
                _snum = _tbiInstrumentManager.TbiServiceTo.PatientSnum;
            }

            if (!string.IsNullOrEmpty(_snum))
            {
                string patICN = patientManager.GetPatientICNBySnum(_snum);

                if (!string.IsNullOrEmpty(patICN)) {
                    ViewState["PatientICN"] = patICN;
                    RefreshSurvey(patICN);
                } else {
                    throw new ArgumentException("Patient with this SSN does not exist.");
                }

                if (_survey != null && !_survey.isNew) {
                    SetUpSurvey(_survey);
                }
                string referrer = "";
                if (Request.UrlReferrer != null) {
                    referrer = Request.UrlReferrer.PathAndQuery;
                }
                ViewState["referrer"] = referrer;
            }

            //Check if the request is to start a new item 
            //a new item page request is signified when the querystring parameter id equals zero or is not present
            if (_tbiInstrumentManager.TbiServiceTo == null) {
                Logging.WriteLogToFile("MedRed_LCI-v2.Page_Load(): WarningRedirect: _tbiInstrumentManager.TbiServiceTo == null");
                //Redirect to message that session is ended and need to log back in from CPRS.
                Response.Redirect("Warning.aspx?err=2");
            } else {
                LabelPatient.Text = BusinessHelper.FixStringToPreventXss(_tbiInstrumentManager.TbiServiceTo.PatientName);
                LabelSSN.Text = BusinessHelper.FixStringToPreventXss(_tbiInstrumentManager.TbiServiceTo.PatientSnum.Trim().Length == 9 ? String.Format("{0:000-00-0000}", int.Parse(_tbiInstrumentManager.TbiServiceTo.PatientSnum)) : _tbiInstrumentManager.TbiServiceTo.PatientSnum);
            }
        }

        QuestionList = GetAllQuestionsForSurvey();

        // Set control values for Diagnosis Question
        ctrlDiagnosis.QuestionText = GetQuestionText("DX");
        ctrlDiagnosis.SurveyTypeCode = HiddenSurveyType.Value;

        LabelDate1.Text = GetQuestionText("18");
        LabelForQ1.Text = GetQuestionText("1");
        LabelForQ2.Text = GetQuestionText("2");
        LabelForQ3.Text = GetQuestionText("3");
        LabelForQ4.Text = GetQuestionText("4");
        LabelForQ5.Text = GetQuestionText("5");
        LabelForQ6.Text = GetQuestionText("6");
        LabelForQ7.Text = GetQuestionText("7");
        LabelForQ8.Text = GetQuestionText("8");
        LabelForQ9.Text = GetQuestionText("9");
        LabelForQ10.Text = GetQuestionText("10");
        LabelForQ11.Text = GetQuestionText("11");
        LabelForQ12.Text = GetQuestionText("12");
        LabelForQ13.Text = GetQuestionText("13");
        LabelForQ14.Text = GetQuestionText("14");

        dpDate1.MaxDate = DateTime.Now;
    }

    protected override void LoadViewState(object savedState) {
        base.LoadViewState(savedState);
        string surveyXml = (string)ViewState["surveyXml"];
        _survey = SerializerUtil.Deserialize<SURVEY>(surveyXml);
    }

    protected override object SaveViewState() {
        ViewState["surveyXml"] = _survey.Serialize();
        return base.SaveViewState();
    }

    /// <summary>
    /// Returns the Question_Text of the question with the passed Question_Number field
    /// </summary>
    /// <param name="questionId"></param>
    /// <returns></returns>
    protected string GetQuestionText(string questionId) {
        foreach (STD_QUESTION ques in QuestionList) {
            if (ques.QUESTION_NUMBER.ToLower() == questionId.ToLower()) {
                return ques.QUESTION_TEXT;
            }
        }

        return "";
    }

    /// <summary>
    /// Returns the Question_Id of the question with the passed Question_Number field
    /// </summary>
    /// <param name="questionId"></param>
    /// <returns></returns>
    protected int GetQuestionId(string questionNumber) {
        foreach (STD_QUESTION ques in QuestionList) {
            if (ques.QUESTION_NUMBER.ToLower() == questionNumber.ToLower()) {
                return ques.ID;
            }
        }

        return 0;
    }

    /// <summary>
    /// Save Draft button clicked.
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    public void btnSaveSurveyDraft_Click(object sender, EventArgs e) {
        Int32 status = 0;
        SaveFailMessage = "Save Failed. Please press " + btnSaveSurveyDraft.Text + " button again to avoid data loss.";
        SaveCompleteSurvey(ref status);
        SetUpSurvey(_survey);
    }

    /// <summary>
    /// Save and Prepare Note button clicked.
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnSubmit_Click(object sender, EventArgs e) {
        Int32 status = 0;
        SaveFailMessage = "Save Failed. Please press " + btnSubmitSurvey.Text + " button again to avoid data loss.";
        SaveCompleteSurvey(ref status);

        if (status > 0) {
            Session["survey"] = _survey;
            Response.Redirect("InstrumentSummaryNote.aspx", false);
        } else {
            SetUpSurvey(_survey); //Follow Save Draft logic 
        }
    }

    /// <summary>
    /// Inactive timer firing.
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void InActiveTimer_Tick(object sender, EventArgs e) {
        Int32 status = 0;
        SaveFailMessage = "Save Failed. Please press " + btnSaveSurveyDraft.Text + " button again to avoid data loss.";

        Page.Validate();

        if (Page.IsValid) {
            SaveCompleteSurvey(ref status);
            //SetUpSurvey(_survey);
            Response.Redirect("MedRed_LCI-v2.aspx", false);
        } else {
            SaveFailMessage = "Auto-Save Validation Failed. Please complete required fields in the survey and press " + btnSaveSurveyDraft.Text + " button again to avoid data loss.";
        }
    }

    /// <summary>
    /// Cancel button clicked.
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnCancel_Click(object sender, EventArgs e) {
        ViewState["surveyXml"] = null;
        ViewState["PatientICN"] = null;
        ViewState["referrer"] = null;
        Session.Remove("survey");
        Response.Redirect("Instrument.aspx", false);
        //this.ClientScript.RegisterStartupScript(typeof(Page), "closePage", "<script type='text/javascript'> window.open('','_self','');window.close(); </script>");
    }

    /// <summary>
    /// Fired when scoring is updated.
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void updateTotals(object sender, EventArgs e) {
        calculateTotals();
    }

    #endregion

    #region Private Methods

    /// <summary>
    /// Get all questions for this survey
    /// </summary>
    /// <returns></returns>
    private List<STD_QUESTION> GetAllQuestionsForSurvey() {
        return _tbiInstrumentManager.SelectAllQuestions(_surveyTypeId).ToList();
    }

    /// <summary>
    /// Refresh Survey
    /// </summary>
    /// <param name="patientICN"></param>
    private void RefreshSurvey(string patientICN) {
        var surveys = _tbiInstrumentManager.SelectByPatientICNAndSurveyType(patientICN, _surveyTypeId, true).ToList();

        if (surveys.Count > 0) {
            _survey = surveys.First();
        } else {
            _survey = new SURVEY();
        }

        _survey.SetAsChangeTrackingRoot();
    }

    /// <summary>
    /// Save Complete Survey
    /// </summary>
    /// <param name="status"></param>
    private void SaveCompleteSurvey(ref Int32 status) {
        Page.Validate();
        if (Page.IsValid) {

            calculateTotals();

            string patientICN = String.Empty;

            status = 0;

            //Retrieve patient's ICN from the session variable
            if (ViewState["PatientICN"] != null) {
                patientICN = ViewState["PatientICN"].ToString();
                if (String.IsNullOrEmpty(patientICN.Trim()))
                {
                    Logging.WriteLogToFile("MedRed_LCI-v2.SaveCompletedSurvey(): WarningRedirect: String.IsNullOrEmpty(patientICN.Trim()");
                    //Lost state. Redirect to message that need to log back in from CPRS.
                    Response.Redirect("Warning.aspx?err=2", false);
                }
            }
            else
            {
                Logging.WriteLogToFile("MedRed_LCI-v2.SaveCompletedSurvey(): WarningRedirect: ViewState[PatientICN] != null");
                //Lost state. Redirect to message that need to log back in from CPRS.
                Response.Redirect("Warning.aspx?err=2");
            }

            if (_survey != null) {
                if (_survey.isNew) {
                    //Ensure that a concurrent session hasn't already inserted a record for this survey
                    var surveys = _tbiInstrumentManager.SelectByPatientICNAndSurveyType(patientICN, _surveyTypeId, true).ToList();

                    if (surveys.Count > 0)
                    {
                        Logging.WriteLogToFile("MedRed_LCI-v2.SaveCompletedSurvey(): WarningRedirect: surveys.Count > 0");
                        //A concurrent session has already inserted a record for this survey and it is not new anymore.
                        Response.Redirect("Warning.aspx?err=9", false);
                    } else {
                        _survey.SURVEY_STATUS = "inprocess";

                        _survey.SetAsInsertOnSubmit();

                        _survey.patient_ICN = patientICN;

                        _survey.STD_SURVEY_TYPE_ID = _surveyTypeId;

                        // TODO: change to datepicker
                        _survey.SURVEY_DATE = DateTime.Today;

                        //Save survey if it's new before adding any responses
                        SuppressSaveMessage = true;
                        _tbiInstrumentManager.Update(_survey);
                        SuppressSaveMessage = false;

                        RefreshSurvey(patientICN);
                    }
                }

                SaveSurvey(ref _survey);

                _survey.SetAsUpdateOnSubmit();
                status = _tbiInstrumentManager.Update(_survey);

                ((RegistryInstrumentMaster)Master).SetDirtyFlag(false);

                RefreshSurvey(patientICN);
                SuppressSaveMessage = false;
            }
        }
    }

    /// <summary>
    /// Save survey.
    /// </summary>
    /// <param name="survey"></param>
    private void SaveSurvey(ref SURVEY survey) {
        List<STD_QUESTION> questions = GetAllQuestionsForSurvey();

        //Delete all the survey results from database if there are any.
        SURVEY surveyWithResults = _tbiInstrumentManager.GetSurveyWithAllAnswers(survey.SURVEYS_ID);
        _tbiInstrumentManager.DeleteAllSurveyResults(surveyWithResults);

        // Question DX
        _surveyResult = new SURVEY_RESULT();

        try {
            // Add Question DX choice
            _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(ctrlDiagnosis.GetSelectedId());
            _surveyResult.RESULT_TEXT = ctrlDiagnosis.GetSelectedResultText();
            survey.SURVEY_RESULTs.Add(_surveyResult);
        } catch (Exception surveyEx) {
            Exception _tbilogerror = HandleTBIException(surveyEx, "MedRed_LCI-v2.aspx", "100027", "SaveSurvey() - Question DX");
        }

        // Question 1. Get up from a chair
        _surveyResult = new SURVEY_RESULT();

        try {
            // Add Question 1 choice
            _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQ1.SelectedValue);
            _surveyResult.RESULT_TEXT = rblQ1.SelectedItem.Text;
            survey.SURVEY_RESULTs.Add(_surveyResult);
        } catch (Exception surveyEx) {
            Exception _tbilogerror = HandleTBIException(surveyEx, "MedRed_LCI-v2.aspx", "100027", "SaveSurvey() - Question1");
        }

        // Question 2. Walk in the house
        _surveyResult = new SURVEY_RESULT();

        try {
            // Add Question 2 choice
            _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQ2.SelectedValue);
            _surveyResult.RESULT_TEXT = rblQ2.SelectedItem.Text;
            survey.SURVEY_RESULTs.Add(_surveyResult);
        } catch (Exception surveyEx) {
            Exception _tbilogerror = HandleTBIException(surveyEx, "MedRed_LCI-v2.aspx", "100027", "SaveSurvey() - Question2");
        }

        // Question 3. Walk outside on even ground
        _surveyResult = new SURVEY_RESULT();

        try {
            // Add Question 3 choice
            _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQ3.SelectedValue);
            _surveyResult.RESULT_TEXT = rblQ3.SelectedItem.Text;
            survey.SURVEY_RESULTs.Add(_surveyResult);
        } catch (Exception surveyEx) {
            Exception _tbilogerror = HandleTBIException(surveyEx, "MedRed_LCI-v2.aspx", "100027", "SaveSurvey() - Question3");
        }

        // Question 4. Go up the stairs with a handrail
        _surveyResult = new SURVEY_RESULT();

        try {
            // Add Question 4 choice
            _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQ4.SelectedValue);
            _surveyResult.RESULT_TEXT = rblQ4.SelectedItem.Text;
            survey.SURVEY_RESULTs.Add(_surveyResult);
        } catch (Exception surveyEx) {
            Exception _tbilogerror = HandleTBIException(surveyEx, "MedRed_LCI-v2.aspx", "100027", "SaveSurvey() - Question4");
        }

        // Question 5. Go down the stairs with a handrail
        _surveyResult = new SURVEY_RESULT();

        try {
            // Add Question 5 choice
            _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQ5.SelectedValue);
            _surveyResult.RESULT_TEXT = rblQ5.SelectedItem.Text;
            survey.SURVEY_RESULTs.Add(_surveyResult);
        } catch (Exception surveyEx) {
            Exception _tbilogerror = HandleTBIException(surveyEx, "MedRed_LCI-v2.aspx", "100027", "SaveSurvey() - Question5");
        }

        // Question 6. Step up a sidewalk curb
        _surveyResult = new SURVEY_RESULT();

        try {
            // Add Question 6 choice
            _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQ6.SelectedValue);
            _surveyResult.RESULT_TEXT = rblQ6.SelectedItem.Text;
            survey.SURVEY_RESULTs.Add(_surveyResult);
        } catch (Exception surveyEx) {
            Exception _tbilogerror = HandleTBIException(surveyEx, "MedRed_LCI-v2.aspx", "100027", "SaveSurvey() - Question6");
        }

        // Question 7. Step down a sidewalk curb
        _surveyResult = new SURVEY_RESULT();

        try {
            // Add Question 7 choice
            _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQ7.SelectedValue);
            _surveyResult.RESULT_TEXT = rblQ7.SelectedItem.Text;
            survey.SURVEY_RESULTs.Add(_surveyResult);
        } catch (Exception surveyEx) {
            Exception _tbilogerror = HandleTBIException(surveyEx, "MedRed_LCI-v2.aspx", "100027", "SaveSurvey() - Question7");
        }

        // Question 8. Pick up an object from the floor (when you are standing with your prothesis
        _surveyResult = new SURVEY_RESULT();

        try {
            // Add Question 8 choice
            _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQ8.SelectedValue);
            _surveyResult.RESULT_TEXT = rblQ8.SelectedItem.Text;
            survey.SURVEY_RESULTs.Add(_surveyResult);
        } catch (Exception surveyEx) {
            Exception _tbilogerror = HandleTBIException(surveyEx, "MedRed_LCI-v2.aspx", "100027", "SaveSurvey() - Question8");
        }

        // Question 9. Get up from the floor (e. g. If you fell)
        _surveyResult = new SURVEY_RESULT();

        try {
            // Add Question 9 choice
            _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQ9.SelectedValue);
            _surveyResult.RESULT_TEXT = rblQ9.SelectedItem.Text;
            survey.SURVEY_RESULTs.Add(_surveyResult);
        } catch (Exception surveyEx) {
            Exception _tbilogerror = HandleTBIException(surveyEx, "MedRed_LCI-v2.aspx", "100027", "SaveSurvey() - Question9");
        }

        // Question 10. Walk outside on uneven ground (e. g. grass, gravel, slope)
        _surveyResult = new SURVEY_RESULT();

        try {
            // Add Question 10 choice
            _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQ10.SelectedValue);
            _surveyResult.RESULT_TEXT = rblQ10.SelectedItem.Text;
            survey.SURVEY_RESULTs.Add(_surveyResult);
        } catch (Exception surveyEx) {
            Exception _tbilogerror = HandleTBIException(surveyEx, "MedRed_LCI-v2.aspx", "100027", "SaveSurvey() - Question10");
        }

        // Question 11. Walk outside in inclement weather (e. g. snow, rain, ice)
        _surveyResult = new SURVEY_RESULT();

        try {
            // Add Question 11 choice
            _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQ11.SelectedValue);
            _surveyResult.RESULT_TEXT = rblQ11.SelectedItem.Text;
            survey.SURVEY_RESULTs.Add(_surveyResult);
        } catch (Exception surveyEx) {
            Exception _tbilogerror = HandleTBIException(surveyEx, "MedRed_LCI-v2.aspx", "100027", "SaveSurvey() - Question11");
        }

        // Question 12. Go up a few steps (stairs) without a handrail
        _surveyResult = new SURVEY_RESULT();

        try {
            // Add Question 12 choice
            _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQ12.SelectedValue);
            _surveyResult.RESULT_TEXT = rblQ12.SelectedItem.Text;
            survey.SURVEY_RESULTs.Add(_surveyResult);
        } catch (Exception surveyEx) {
            Exception _tbilogerror = HandleTBIException(surveyEx, "MedRed_LCI-v2.aspx", "100027", "SaveSurvey() - Question12");
        }

        // Question 13. Go down a few steps (stairs) without a handrail
        _surveyResult = new SURVEY_RESULT();

        try {
            // Add Question 13 choice
            _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQ13.SelectedValue);
            _surveyResult.RESULT_TEXT = rblQ13.SelectedItem.Text;
            survey.SURVEY_RESULTs.Add(_surveyResult);
        } catch (Exception surveyEx) {
            Exception _tbilogerror = HandleTBIException(surveyEx, "MedRed_LCI-v2.aspx", "100027", "SaveSurvey() - Question13");
        }

        // Question 14. Walk while carrying an object
        _surveyResult = new SURVEY_RESULT();

        try {
            // Add Question 14 choice
            _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQ14.SelectedValue);
            _surveyResult.RESULT_TEXT = rblQ14.SelectedItem.Text;
            survey.SURVEY_RESULTs.Add(_surveyResult);
        } catch (Exception surveyEx) {
            Exception _tbilogerror = HandleTBIException(surveyEx, "MedRed_LCI-v2.aspx", "100027", "SaveSurvey() - Question14");
        }

        // Basic activities score - Question 15 (hidden)
        STD_QUESTION question15 = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "15");
        _surveyResult = new SURVEY_RESULT();

        try {
            // Add Question 15 choice
            _surveyResult.STD_QUESTION_CHOICE_ID = question15.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
            _surveyResult.RESULT_TEXT = HiddenBasicScore.Value;
            survey.SURVEY_RESULTs.Add(_surveyResult);
        } catch (Exception surveyEx) {
            Exception _tbilogerror = HandleTBIException(surveyEx, "MedRed_LCI-v2.aspx", "100027", "SaveSurvey() - Question15");
        }

        // Advanced activities score - Question 16 (hidden)
        STD_QUESTION question16 = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "16");
        _surveyResult = new SURVEY_RESULT();

        try {
            // Add Question 16 choice
            _surveyResult.STD_QUESTION_CHOICE_ID = question16.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
            _surveyResult.RESULT_TEXT = HiddenAdvancedScore.Value;
            survey.SURVEY_RESULTs.Add(_surveyResult);
        } catch (Exception surveyEx) {
            Exception _tbilogerror = HandleTBIException(surveyEx, "MedRed_LCI-v2.aspx", "100027", "SaveSurvey() - Question16");
        }

        // Total score - Question 17 (hidden)
        STD_QUESTION question17 = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "17");
        _surveyResult = new SURVEY_RESULT();

        try {
            // Add Question 17 choice
            _surveyResult.STD_QUESTION_CHOICE_ID = question17.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
            _surveyResult.RESULT_TEXT = HiddenTotalScore.Value;
            survey.SURVEY_RESULTs.Add(_surveyResult);
        } catch (Exception surveyEx) {
            Exception _tbilogerror = HandleTBIException(surveyEx, "MedRed_LCI-v2.aspx", "100027", "SaveSurvey() - Question17");
        }

        // Question 18 - Date
        if (dpDate1.SelectedDate != null) {
            STD_QUESTION question18 = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "18");
            _surveyResult = new SURVEY_RESULT();

            try {
                // Add Question 18 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = question18.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
                _surveyResult.RESULT_TEXT = ((DateTime)dpDate1.SelectedDate).ToShortDateString();
                survey.SURVEY_RESULTs.Add(_surveyResult);
            } catch (Exception surveyEx) {
                Exception _tbilogerror = HandleTBIException(surveyEx, "MedRed_L-Test.aspx", "100027", "SaveSurvey() - Question18");
            }
        }
    }// END SaveSurvey

    /// <summary>
    /// Initialize/setup controls
    /// </summary>
    /// <param name="survey"></param>
    private void SetUpSurvey(SURVEY survey) {
        try {
            foreach (var sResult in survey.SURVEY_RESULTs) {
                switch (sResult.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER) {
                    case "DX":
                        if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1) {
                            ctrlDiagnosis.SelectedChoiceId = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();

                            if (sResult.STD_QUESTION_CHOICE.CHOICE_TEXT.ToLower().Contains("other")) {
                                ctrlDiagnosis.SetOtherDescriptionText(sResult.RESULT_TEXT);
                            }
                        } else {
                            ctrlDiagnosis.SelectedChoiceId = null;
                        }
                        break;
                    case "1":
                        if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1) {
                            rblQ1.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                        } else {
                            rblQ1.SelectedIndex = -1;
                        }

                        break;
                    case "2":
                        if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1) {
                            rblQ2.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                        } else {
                            rblQ2.SelectedIndex = -1;
                        }

                        break;
                    case "3":
                        if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1) {
                            rblQ3.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                        } else {
                            rblQ3.SelectedIndex = -1;
                        }

                        break;
                    case "4":
                        if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1) {
                            rblQ4.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                        } else {
                            rblQ4.SelectedIndex = -1;
                        }

                        break;
                    case "5":
                        if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1) {
                            rblQ5.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                        } else {
                            rblQ5.SelectedIndex = -1;
                        }

                        break;
                    case "6":
                        if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1) {
                            rblQ6.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                        } else {
                            rblQ6.SelectedIndex = -1;
                        }

                        break;
                    case "7":
                        if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1) {
                            rblQ7.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                        } else {
                            rblQ7.SelectedIndex = -1;
                        }

                        break;
                    case "8":
                        if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1) {
                            rblQ8.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                        } else {
                            rblQ8.SelectedIndex = -1;
                        }

                        break;
                    case "9":
                        if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1) {
                            rblQ9.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                        } else {
                            rblQ9.SelectedIndex = -1;
                        }

                        break;
                    case "10":
                        if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1) {
                            rblQ10.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                        } else {
                            rblQ10.SelectedIndex = -1;
                        }

                        break;
                    case "11":
                        if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1) {
                            rblQ11.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                        } else {
                            rblQ11.SelectedIndex = -1;
                        }

                        break;
                    case "12":
                        if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1) {
                            rblQ12.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                        } else {
                            rblQ12.SelectedIndex = -1;
                        }

                        break;
                    case "13":
                        if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1) {
                            rblQ13.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                        } else {
                            rblQ13.SelectedIndex = -1;
                        }

                        break;
                    case "14":
                        if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1) {
                            rblQ14.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                        } else {
                            rblQ14.SelectedIndex = -1;
                        }

                        break;
                    case "15":
                        if (!String.IsNullOrEmpty(sResult.RESULT_TEXT)) {
                            lblBasicActivitiesScore.Text = HiddenBasicScore.Value = BusinessHelper.FixStringToPreventXss(sResult.RESULT_TEXT);
                        }
                        
                        break;
                    case "16":
                        if (!String.IsNullOrEmpty(sResult.RESULT_TEXT)) {
                            lblAdvancedActivitiesScore.Text = HiddenAdvancedScore.Value = BusinessHelper.FixStringToPreventXss(sResult.RESULT_TEXT);
                        }

                        break;
                    case "17":
                        if (!String.IsNullOrEmpty(sResult.RESULT_TEXT)) {
                            lblTotalActivitiesScore.Text = HiddenTotalScore.Value = BusinessHelper.FixStringToPreventXss(sResult.RESULT_TEXT);
                        }
                        break;
                    case "18":
                        // Date
                        if (!String.IsNullOrEmpty(sResult.RESULT_TEXT)) {
                            DateTime temp;
                            if (DateTime.TryParse(sResult.RESULT_TEXT, out temp)) {
                                dpDate1.SelectedDate = temp;
                            }
                        }
                        break;
                    default:
                        break;
                }
            }
        } catch (Exception ex) {
            Exception _tbilogerror = HandleTBIException(ex, "MedRed_LCI-v2.aspx", "100027", "SetUpSurvey()");
        }
    }// END SetUpSurvey

    /// <summary>
    /// performs total calcuation
    /// </summary>
    private void calculateTotals() {
        #region calculate basic

        int basicScore = 0;

        if (rblQ1.SelectedIndex > -1) {
            basicScore += Convert.ToInt32(rblQ1.SelectedItem.Text);
        }

        if (rblQ2.SelectedIndex > -1) {
            basicScore += Convert.ToInt32(rblQ2.SelectedItem.Text);
        }

        if (rblQ3.SelectedIndex > -1) {
            basicScore += Convert.ToInt32(rblQ3.SelectedItem.Text);
        }

        if (rblQ4.SelectedIndex > -1) {
            basicScore += Convert.ToInt32(rblQ4.SelectedItem.Text);
        }

        if (rblQ5.SelectedIndex > -1) {
            basicScore += Convert.ToInt32(rblQ5.SelectedItem.Text);
        }

        if (rblQ6.SelectedIndex > -1) {
            basicScore += Convert.ToInt32(rblQ6.SelectedItem.Text);
        }

        if (rblQ7.SelectedIndex > -1) {
            basicScore += Convert.ToInt32(rblQ7.SelectedItem.Text);
        }

        lblBasicActivitiesScore.Text = basicScore.ToString();

        #endregion

        #region calculate advanced

        int advancedScore = 0;

        if (rblQ8.SelectedIndex > -1) {
            advancedScore += Convert.ToInt32(rblQ8.SelectedItem.Text);
        }

        if (rblQ9.SelectedIndex > -1) {
            advancedScore += Convert.ToInt32(rblQ9.SelectedItem.Text);
        }

        if (rblQ10.SelectedIndex > -1) {
            advancedScore += Convert.ToInt32(rblQ10.SelectedItem.Text);
        }

        if (rblQ11.SelectedIndex > -1) {
            advancedScore += Convert.ToInt32(rblQ11.SelectedItem.Text);
        }

        if (rblQ12.SelectedIndex > -1) {
            advancedScore += Convert.ToInt32(rblQ12.SelectedItem.Text);
        }

        if (rblQ13.SelectedIndex > -1) {
            advancedScore += Convert.ToInt32(rblQ13.SelectedItem.Text);
        }

        if (rblQ14.SelectedIndex > -1) {
            advancedScore += Convert.ToInt32(rblQ14.SelectedItem.Text);
        }

        lblAdvancedActivitiesScore.Text = advancedScore.ToString();

        #endregion

        // calculate total
        int totalScore = basicScore + advancedScore;
        lblTotalActivitiesScore.Text = totalScore.ToString();

        HiddenBasicScore.Value = basicScore.ToString();
        HiddenAdvancedScore.Value = advancedScore.ToString();
        HiddenTotalScore.Value = totalScore.ToString();
    }

    #endregion
}